package row_data_gateway;
import db_context.DbContext;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Package {
    private Integer id;
    private boolean insurance;
    private BigDecimal delivery_price = new BigDecimal(0);
    private String status = "new";
    private Integer delivery_attempts = 0;
    private Integer damage = 0;
    private Integer sender_id;
    private Integer recipient_id;

    public Integer getId() {
        return id;
    }
    public void setId(Integer id) {
        this.id = id;
    }

    public boolean getInsurance(){
        return insurance;
    }
    public void setInsurance(boolean insurance){
        this.insurance = insurance;
    }

    public void setInsurance(String insurance){
        if(insurance.equals("Yes") || insurance.equals("yes") || insurance.equals("y")){
            this.insurance = true;
        }
    }
    public BigDecimal getDelivery_price() { return delivery_price; }
    public void setDelivery_price(BigDecimal delivery_price) { this.delivery_price = delivery_price; }

    public String getStatus() { return status; }
    public void setStatus(String status) { this.status = status; }

    public Integer getDelivery_attempts() { return delivery_attempts; }
    public void setDelivery_attempts(Integer delivery_attempts) { this.delivery_attempts = delivery_attempts; }

    public Integer getDamage() { return damage; }
    public void setDamage(Integer damage) { this.damage = damage; }

    public Integer getSender_id() { return sender_id; }
    public void setSender_id(Integer sender_id){ this.sender_id = sender_id; }

    public Integer getRecipient_id() { return recipient_id; }
    public void setRecipient_id(Integer recipient_id) { this.recipient_id = recipient_id; }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO packages (insurance, delivery_price, status, delivery_attempts, damage, sender_id, recipient_id) VALUES (?,?,?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setBoolean(1, insurance);
            s.setBigDecimal(2, delivery_price);
            s.setString(3, status);
            s.setInt(4, delivery_attempts);
            s.setInt(5, damage);
            s.setInt(6, sender_id);
            s.setInt(7, recipient_id);
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE packages SET insurance = ?, delivery_price = ?, status = ?, delivery_attempts = ?, damage = ?, sender_id = ?, recipient_id = ? WHERE id = ?")) {
            s.setBoolean(1, insurance);
            s.setBigDecimal(2, delivery_price);
            s.setString(3, status);
            s.setInt(4,delivery_attempts);
            s.setInt(5, damage);
            s.setInt(6, sender_id);
            s.setInt(7, recipient_id);
            s.setInt(8, id);
            s.executeUpdate();
        }
    }
    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM packages WHERE id = ?")) {
            s.setInt(1, id);
            s.executeUpdate();
        }
    }
}
